(*--------------------------------------------------------------------**
**	    	Fa. MAMAvision Software Consult                             **
**		    Wollmatingerstrae 70b  D-78467 Konstanz                    **
**	      Tel.: (07531)690014     Fax: (07531)690015                  **
**--Projekt-----------------------------------------------------------**
**		               	 Copy to Port/File-Komponente                   **
**                     SOFTWARE\MMPLOT\VCL\....                       **
**--Revisionhistory---------------------------------------------------**
**
log
**
**--Module------------------------------------------------------------**
**  Modul-Name      : modname
**  Modul-Revision  : version
**  Projekt-Revision: release
**--------------------------------------------------------------------**
nokeywords
**---------------------------------------------------------------------*)
unit MMPort_u;
(*--------------------------------------------------------------------*)
(*   Portkommunicationskomponente                                     *)
(*--------------------------------------------------------------------*)
interface
uses  Messages, classes, wintypes, winprocs, graphics, sysutils,
      Forms, Printers, FileCtrl, Dialogs, IniFiles, Controls, ExtCtrls,
      Dsgnintf, ClipBrd;
{$define ENGLISH}    { remove $ if german required }
(************************ TMMPort control ************************)
{ These are the enumerated types supported by the TMMPort control }
type
  TBaudRate = (br110, br300, br600, br1200, br2400, br4800, br9600, br14400,
               br19200, br38400, br56000, br128000, br256000);
  TParityBits = (pbNone, pbOdd, pbEven, pbMark, pbSpace);
  TDataBits = (dbFour, dbFive, dbSix, dbSeven, dbEight);
  TStopBits = (sbOne, sbOnePointFive, sbTwo);
  TCommEvent = (ceBreak, ceCts, ceCtss, ceDsr, ceErr, cePErr, ceRing, ceRlsd,
                ceRlsds, ceRxChar, ceRxFlag, ceTxEmpty);
  TFlowControl = (fcNone, fcRTSCTS, fcXONXOFF);
  TCommEvents = set of TCommEvent;
  { These are the events for the TComm object }
  TNotifyCommEventEvent = procedure(Sender: TObject; CommEvent: TCommEvents) of object;
  TNotifyReceiveEvent = procedure(Sender: TObject; Count: Word) of object;
  TNotifyTransmitLowEvent = procedure(Sender: TObject; Count: Word) of object;
  { This is the TMMPort object }
  TMMPort = class(TComponent)
  protected
    FVersion: Single;
    FPort: integer;
    FSerial: Boolean;
    FParseOnly:boolean;
    FBaudRate: TBaudRate;
    FParityBits: TParityBits;
    FDataBits: TDataBits;
    FStopBits: TStopBits;
    FFlowControl: TFlowControl;
    FRxBufSize: Word;
    FTxBufSize: Word;
    FRxFull: Word;
    FTxLow: Word;
    FEvents: TCommEvents;
    FOnCommEvent: TNotifyCommEventEvent;
    FOnReceive: TNotifyReceiveEvent;
    FOnTransmitLow: TNotifyTransmitLowEvent;
    FhWnd: hWnd;
    cId: Integer;                        { handle to comm port }
    DCB: TDCB;
    Error: String;
    FDestination:string;
    FSendDirect :boolean;
    procedure SetPort(Value: integer);
    procedure SetPortStr(Value: String);
    procedure SetBaudRate(Value: TBaudRate);
    procedure SetParityBits(Value: TParityBits);
    procedure SetDataBits(Value: TDataBits);
    procedure SetStopBits(Value: TStopBits);
    procedure SetFlowControl(Value: TFlowControl);
    procedure SetRxBufSize(Value: Word);
    procedure SetTxBufSize(Value: Word);
    procedure SetRxFull(Value: Word);
    procedure SetTxLow(Value: Word);
    procedure SetEvents(Value: TCommEvents);
    procedure WndProc(var Msg: TMessage);
    procedure DoEvent;
    procedure DoReceive;
    procedure DoTransmit;
    function parseOpenErr(Errcode: Integer): String;
    function parseGenErr: String;
    function GetPortStr: String;
    procedure SendPort(FName: TFilename);
    procedure CopyPort(FName: TFilename);
    procedure SetDestination(Value: String);
  public
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
    procedure Write(Data: PChar; Len: Word);
    procedure Read(Data: PChar; Len: Word);
    procedure GetPortsAvail(SerialOnly: boolean;List: TStrings);
    function  Open: Boolean;
    procedure Close;
    function  GetError: String;
    procedure SendFile(FName: TFilename);
  published
    property Version: Single read FVersion;
    property Port: integer read FPort write SetPort;
    property PortName: string read GetPortStr write SetPortStr;
    property DirecttoPort:boolean read FSendDirect write FSendDirect default true;
    property Destination: string read FDestination write SetDestination;
    property BaudRate: TBaudRate read FBaudRate write SetBaudRate;
    property ParityBits: TParityBits read FParityBits write SetParityBits;
    property DataBits: TDataBits read FDataBits write SetDataBits;
    property StopBits: TStopBits read FStopBits write SetStopBits;
    property FlowControl: TFlowControl read FFlowControl write SetFlowControl;
    property TxBufSize: Word read FTxBufSize write SetTxBufSize;
    property RxBufSize: Word read FRxBufSize write SetRxBufSize;
    property Events: TCommEvents read FEvents write SetEvents;
    property OnCommEvent: TNotifyCommEventEvent read FOnCommEvent write FOnCommEvent;
    property OnReceive: TNotifyReceiveEvent read FOnReceive write FOnReceive;
    property OnTransmitLow: TNotifyTransmitLowEvent read FOnTransmitLow write FOnTransmitLow;
  end;

FUNCTION  fCopy(Const cSource, cDest: String): boolean;

implementation

const
{$ifdef ENGLISH}
txt_CommOpenErr='Open port failed';
txt_SelectPort = 'No valid port selected';
txt_NoPortAvail = 'No valid port available';
txt_BADID = 'Device identifier is invalid or unsupported';
txt_OPEN = 'Device is already open.';
txt_NOPEN = 'Device is not open.';
txt_MEMORY = 'Cannot allocate queues.';
txt_DEFAULT = 'Default parameters are in error.';
txt_HARDWARE = 'Hardware not available (locked by another device).';
txt_BYTESIZE = 'Specified byte size is invalid.';
txt_BAUDRATE = 'Device baud rate is unsupported.';
txt_OpenErr = 'Open error ';
{$else}
txt_CommOpenErr = 'Kann Anschlu nicht ffnen';
txt_SelectPort = 'Bitte Anschlu whlen';
txt_NoPortAvail = 'Kein Anschlu verfgbar';
txt_BADID = 'Gertenummer ist ungltig bzw. wird nicht untersttzt';
txt_OPEN = 'Anschlu ist bereits geffnet.';
txt_NOPEN = 'Anschlu ist nicht geffnet.';
txt_MEMORY = 'Kann Warteschlange nicht einrichten.';
txt_DEFAULT = 'Default Parameter sind ungltig.';
txt_HARDWARE = 'Anschlu ist nicht verfgbar bzw. von anderem Gert blockiert).';
txt_BYTESIZE = 'Spezifizierte Bytegre ist ungltig.';
txt_BAUDRATE = 'Baudrate wird von diesem Gert nicht untersttzt.';
txt_OpenErr = 'Kommunikationsfehler beim ffnen aufgetreten';
{$endif}
txt_COM = 'COM';
txt_LPT = 'LPT';
(******************************* MSComm   **********************************)
{ Set com port value. Used when you open the port. NOTE: This only takes effect when
 opening the port-- obviously! Only works for ports 1 thru 9 currently, though I
 think newer versions of Windows support up to 254 comm ports. Set this to port
 zero (0) if you want to disable the comm control.}
procedure TMMPort.SetPort(Value: integer);
begin
  FSerial := Value > -1;
  If FSerial then
  begin
    If Value > 255 then exit;
    FPort := Value
  end else
  begin
    If Value < -3 then exit;
    FPort := Value;
  end;
end;

{ Set baud rate: 110-256,000. Notice that this will change the baud rate of the port
 immediately-- if it is currently open! This goes for most of the other com port
 settings below as well.}
procedure TMMPort.SetBaudRate(Value: TBaudRate);
var
  DCB: TDCB;
begin
  FBaudRate := Value;
  If not FSerial then exit;
  if cId >= 0 then begin
    GetCommState(cId, DCB);
    case Value of
      br110: DCB.BaudRate := CBR_110;
      br300: DCB.BaudRate := CBR_300;
      br600: DCB.BaudRate := CBR_600;
      br1200: DCB.BaudRate := CBR_1200;
      br2400: DCB.BaudRate := CBR_2400;
      br4800: DCB.BaudRate := CBR_4800;
      br9600: DCB.BaudRate := CBR_9600;
      br14400: DCB.BaudRate := CBR_14400;
      br19200: DCB.BaudRate := CBR_19200;
      br38400: DCB.BaudRate := CBR_38400;
      br56000: DCB.BaudRate := CBR_56000;
      br128000: DCB.BaudRate := CBR_128000;
      br256000: DCB.BaudRate := CBR_256000;
    end;
    SetCommState(DCB);
  end;
end;

{ set parity: none, odd, even, mark, space }
procedure TMMPort.SetParityBits(Value: TParityBits);
var
  DCB: TDCB;
begin
  FParityBits := Value;
  If not FSerial then exit;
  if cId < 0 then
    exit;
  GetCommState(cId, DCB);
  case Value of
    pbNone: DCB.Parity := 0;
    pbOdd: DCB.Parity := 1;
    pbEven: DCB.Parity := 2;
    pbMark: DCB.Parity := 3;
    pbSpace: DCB.Parity := 4;
  end;
  SetCommState(DCB);
end;

{ set # of data bits 4-8 }
procedure TMMPort.SetDataBits(Value: TDataBits);
var
  DCB: TDCB;
begin
  FDataBits := Value;
  If not FSerial then exit;
  if cId < 0 then
    exit;
  GetCommState(cId, DCB);
  case Value of
    dbFour: DCB.ByteSize := 4;
    dbFive: DCB.ByteSize := 5;
    dbSix: DCB.ByteSize := 6;
    dbSeven: DCB.ByteSize := 7;
    dbEight: DCB.ByteSize := 8;
  end;
  SetCommState(DCB);
end;

{ set number of stop bits 1, 1.5 or 2 }
procedure TMMPort.SetStopBits(Value: TStopBits);
var
  DCB: TDCB;
begin
  FStopBits := Value;
  If not FSerial then exit;
  if cId < 0 then
    exit;
  GetCommState(cId, DCB);
  case Value of
    sbOne: DCB.StopBits := 0;
    sbOnePointFive: DCB.StopBits := 1;
    sbTwo: DCB.StopBits := 2;
  end;
  SetCommState(DCB);
end;

{ Set flow control: None, RTS/CTS, or Xon/Xoff. Flow control works in conjunction
with the read and write buffers to ensure that the flow of data *will* stop if
the buffers get critically full. If there is no flow control, it's possible
to lose data.. with flow control on, technically, it's impossible since if the
buffers get full, flow control will kick in and stop the data flow until the
buffers have time to get clear. }
procedure TMMPort.SetFlowControl(Value: TFlowControl);
var
  DCB: TDCB;
begin
  FFlowControl := Value;
  if cId < 0 then
    exit;
  GetCommState(cId, DCB);
  DCB.Flags := DCB.Flags xor (dcb_OutxCtsFlow or dcb_Rtsflow or dcb_OutX or dcb_InX);
  case Value of
    fcNone: ;
    fcRTSCTS: DCB.Flags := DCB.Flags or dcb_OutxCtsFlow or dcb_Rtsflow;
    fcXONXOFF: DCB.Flags := DCB.Flags or dcb_OutX or dcb_InX;
  end;
  SetCommState(DCB);
end;

{ RxBuf is the amount of memory set aside to buffer reads (incoming data)
to the serial port. It is possible to overflow the read buffer depending on how
frequently you are servicing (reading) the incoming data and how fast data is
coming in the serial port. NOTE: This setting takes effect only when opening
the port. }
procedure TMMPort.SetRxBufSize(Value: Word);
begin
  FRxBufSize := Value;
end;

{ TxBuf is the amount of memory set aside to buffer writes (outgoing data)
to the serial port. Must be larger than any chunk of data you plan to write at
once. It is possible to overflow the tx buffer depending on how fast data
is going out of the modem, and how fast you're writing to the serial port. NOTE: this
setting takes effect only when opening the port. }
procedure TMMPort.SetTxBufSize(Value: Word);
begin
  FTxBufSize := Value;
end;

{ RxFull indicates the number of bytes the COM driver must write to the
application's input queue before sending a notification message. The message
signals the application to read information from the input queue. This "forces"
the driver to send notification during periods of data "streaming." It will
stop what it's doing and notify you when it gets at least this many chars.
This will only affect data streaming; normally data is sent during lulls in
the "stream." If there are no lulls, this setting comes into effect. The
event OnReceive fires when ANY amount of data is received. The maximum
chunk of data you will receive is set by the RxFull amount. }
procedure TMMPort.SetRxFull(Value: Word);
begin
  FRxFull := Value;
  if cId < 0 then
    exit;
  EnableCommNotification(cId, FhWnd, FRxFull, FTxLow);
end;

{ TxLow Indicates the minimum number of bytes in the output queue. When the
number of bytes in the output queue falls below this number, the COM driver
sends the application a notification message, signaling it to write information
to the output queue. This can be handy to avoid overflowing the (outgoing)
read buffer. The event OnTransmitLow fires when this happens.}
procedure TMMPort.SetTxLow(Value: Word);
begin
  FTxLow := Value;
  if cId < 0 then
    exit;
  EnableCommNotification(cId, FhWnd, FRxFull, FTxLow);
end;

{ Build the event mask. Indicates which misc events we want the comm control to
tell us about. }
procedure TMMPort.SetEvents(Value: TCommEvents);
var
  Events: Word;
begin
  FEvents := Value;
  if cId < 0 then
    exit;
  Events := 0;
  if ceBreak in FEvents then Events := Events or EV_BREAK;
  if ceCts in FEvents then Events := Events or EV_CTS;
  if ceCtss in FEvents then Events := Events or EV_CTSS;
  if ceDsr in FEvents then Events := Events or EV_DSR;
  if ceErr in FEvents then Events := Events or EV_ERR;
  if cePErr in FEvents then Events := Events or EV_PERR;
  if ceRing in FEvents then Events := Events or EV_RING;
  if ceRlsd in FEvents then Events := Events or EV_RLSD;
  if ceRlsds in FEvents then Events := Events or EV_RLSDS;
  if ceRxChar in FEvents then Events := Events or EV_RXCHAR;
  if ceRxFlag in FEvents then Events := Events or EV_RXFLAG;
  if ceTxEmpty in FEvents then Events := Events or EV_TXEMPTY;
  SetCommEventMask(cId, Events);
end;

{ This is the message handler for the invisible window; it handles comm msgs
that are handed to the invisible window. We hook into these messages using
EnableCommNotification and our invisible window handle. This routine hands
off to the "do(x)" routines below. }
procedure TMMPort.WndProc(var Msg: TMessage);
begin
  with Msg do begin
    if Msg = WM_COMMNOTIFY then begin
      case lParamLo of
        CN_EVENT   : DoEvent;
        CN_RECEIVE : DoReceive;
        CN_TRANSMIT: DoTransmit;
      end;
      end
    else
      Result := DefWindowProc(FhWnd, Msg, wParam, lParam);
  end;
end;

{ some comm event occured. see if we need to report it as an event based
 on the FOnEvent flags set in the control. }
procedure TMMPort.DoEvent;
var
  CommEvent: TCommEvents;
  Events: Word;
begin
  if (cId < 0) or not Assigned(FOnCommEvent) then
    exit;
  Events := GetCommEventMask(cId, Integer($FFFF));
  CommEvent := [];
  if (ceBreak in FEvents) and (events and EV_BREAK <> 0) then
    CommEvent := CommEvent + [ceBreak];
  if (ceCts in FEvents) and (events and EV_CTS <> 0) then
    CommEvent := CommEvent + [ceCts];
  if (ceCtss in FEvents) and (events and EV_CTSS <> 0) then
    CommEvent := CommEvent + [ceCtss];
  if (ceDsr in FEvents) and (events and EV_DSR <> 0) then
    CommEvent := CommEvent + [ceDsr];
  if (ceErr in FEvents) and (events and EV_ERR <> 0) then
    CommEvent := CommEvent + [ceErr];
  if (cePErr in FEvents) and (events and EV_PERR <> 0) then
    CommEvent := CommEvent + [cePErr];
  if (ceRing in FEvents) and (events and EV_RING <> 0) then
    CommEvent := CommEvent + [ceRing];
  if (ceRlsd in FEvents) and (events and EV_RLSD <> 0) then
    CommEvent := CommEvent + [ceRlsd];
  if (ceRlsds in FEvents) and (events and EV_RLSDS <> 0) then
    CommEvent := CommEvent + [ceRlsds];
  if (ceRxChar in FEvents) and (events and EV_RXCHAR <> 0) then
    CommEvent := CommEvent + [ceRxChar];
  if (ceRxFlag in FEvents) and (events and EV_RXFLAG <> 0) then
    CommEvent := CommEvent + [ceRxFlag];
  if (ceTxEmpty in FEvents) and (events and EV_TXEMPTY <> 0) then
    CommEvent := CommEvent + [ceTxEmpty];
  FOnCommEvent(Self, CommEvent);
end;

{ we rec'd some data, see if receive event is on and fire }
procedure TMMPort.DoReceive;
var
  Stat: TComStat;
begin
  if (cId < 0) or not Assigned(FOnReceive) then
    exit;
  GetCommError(cId, Stat);
  FOnReceive(Self, Stat.cbInQue);
  GetCommError(cId, Stat);
end;

{ This event will fire when the transmit buffer goes BELOW the point set
 in txLowCount. It will NOT fire when a transmission takes place. }
procedure TMMPort.DoTransmit;
var
  Stat: TComStat;
begin
  if (cId < 0) or not Assigned(FOnTransmitLow) then
    exit;
  GetCommError(cId, Stat);
  FOnTransmitLow(Self, Stat.cbOutQue);
end;

{ construct: create invisible message window, set default values }
constructor TMMPort.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  FhWnd := AllocateHWnd(WndProc);
  Error := '';
  FVersion := 1.10;
  FPort := 2;
  FBaudRate := br9600;
  FParityBits := pbNone;
  FDataBits := dbEight;
  FStopBits := sbOne;
  FTxBufSize := 2048;
  FRxBufSize := 2048;
  FRxFull := 512;
  FTxLow := 512;
  FEvents := [];
  cId := -1;
  FParseOnly := false;
end;

{ destructor: close invisible message window, close comm port }
destructor TMMPort.Destroy;
begin
  DeallocatehWnd(FhWnd);
  if cId >= 0 then
    CloseComm(cId);
  inherited Destroy;
end;

{ Write data to comm port. This routine will reject an attempt
 to write a chunk of data larger than the write buffer size. WARNING: This
 routine could *potentially* wait forever for the buffer to clear. But at least
 your machine won't lock up since we're processing messages in the wait loop.
 NOTE: theoretically, you should check the Error property for errors
 after every write. Any error during read or write can stop flow of data. }
procedure TMMPort.Write(Data: PChar; Len: Word);
var
  Stat: TComStat;
  bufroom: Integer;
begin
  if cId < 0 then
    exit;
  if Len > FTxBufSize then begin
{$ifdef ENGLISH}
    Error := 'write larger than transmit buffer size';
{$else}
    Error := 'Schreibversuch ber den bertragungspuffer hinaus';
{$endif}
    exit;
  end;

  repeat
    GetCommError(cId, Stat);
    bufroom := FTxBufSize - stat.cbOutQue;
    Application.ProcessMessages;
  until bufroom >= len;

  if WriteComm(cId, Data, Len) < 0 then
    Error := ParseGenErr;
  GetCommEventMask(cId, Integer($FFFF));
end;

{ Read data from comm port. Should only do read when you've been notified you
 have data. Attempting to read when nothing is in read buffer results
 in spurious error. You can never read a larger chunk than the read buffer
 size. NOTE: theoretically, you should check the Error property for errors
 after every read. Any error during read or write can stop flow of data. }
procedure TMMPort.Read(Data: PChar; Len: Word);
begin
  if cId < 0 then
    exit;
  if ReadComm(cId, Data, Len) < 0 then
    Error := ParseGenErr;
  GetCommEventMask(cId, Integer($FFFF));
end;


{ failure to open results in a negative cId, this will translate the
  negative cId value into an explanation. }
function TMMPort.parseOpenErr(Errcode: Integer): String;
begin
  case errcode of
    IE_BADID: result := txt_BADID;
    IE_OPEN: result := txt_OPEN;
    IE_NOPEN: result := txt_NOPEN;
    IE_MEMORY: result := txt_MEMORY;
    IE_DEFAULT: result := txt_DEFAULT;
    IE_HARDWARE: result := txt_HARDWARE;
    IE_BYTESIZE: result := txt_BYTESIZE;
    IE_BAUDRATE: result := txt_BAUDRATE;
 else
    result := txt_OpenErr + IntToStr(Errcode);
 end;
end;

{ failure to read or write to comm port results in a negative returned
value. This will translate the value into an explanation. }
function TMMPort.ParseGenErr: String;
var
  stat: TComStat;
  errCode: Word;
begin
  errCode := GetCommError(cId, stat);
{$ifdef ENGLISH}
  case errcode of
    CE_BREAK: result := 'Hardware detected a break condition.';
    CE_CTSTO: result := 'CTS (clear-to-send) timeout.';
    CE_DNS: result := 'Parallel device was not selected.';
    CE_DSRTO: result := 'DSR (data-set-ready) timeout.';
    CE_FRAME: result := 'Hardware detected a framing error.';
    CE_IOE: result := 'I/O error during communication with parallel device.';
    CE_MODE: result := 'Requested mode is not supported';
    CE_OOP: result := 'Parallel device is out of paper.';
    CE_OVERRUN: result := 'Character was overwritten before it could be retrieved.';
    CE_PTO: result := 'Timeout during communication with parallel device.';
    CE_RLSDTO: result := 'RLSD (receive-line-signal-detect) timeout.';
    CE_RXOVER: result := 'Receive buffer overflow.';
    CE_RXPARITY: result := 'Hardware detected a parity error.';
    CE_TXFULL: result := 'Transmit buffer overflow.';
  else
    result := 'General error ' + IntToStr(errcode);
  end;
{$else}
  case errcode of
    CE_BREAK: result := 'Hardware meldet "Break-Condition".';
    CE_CTSTO: result := 'CTS (clear-to-send) timeout.';
    CE_DNS: result := 'Parallelanschlu war nicht selektiert.';
    CE_DSRTO: result := 'DSR (data-set-ready) timeout.';
    CE_FRAME: result := 'Hardware meldet einen framing-Fehler.';
    CE_IOE: result := 'I/O Fehler whrend der Kommunikation mit Parallelanschlu.';
    CE_MODE: result := 'Der angeforderte Modus wird nicht untersttzt';
    CE_OOP: result := 'Parallelanschlu meldet "Out of paper".';
    CE_OVERRUN: result := 'Zeichen wurde berschrieben, bevor es abgeholt wurde.';
    CE_PTO: result := 'Timeout whrend der Kommunikation mit Parallelanschlu.';
    CE_RLSDTO: result := 'RLSD (receive-line-signal-detect) timeout.';
    CE_RXOVER: result := 'Empfangspuffer-berlauf.';
    CE_RXPARITY: result := 'Hardware meldet einen Parittsfehler .';
    CE_TXFULL: result := 'Sendepuffer-berlauf.';
  else
    result := 'Kommunikationsfehler aufgetreten ' + IntToStr(errcode);
  end;
{$endif}
end;

{ returns error text (if any) and clears it }
function TMMPort.GetError: String;
begin
  Result := Error;
  Error := '';
end;

(*************** Added some functionality: Markus **********************)
procedure TMMPort.SetPortStr(Value: string);
var i,ierr:integer;
begin
  Value := Uppercase(Value);
  i := pos(':',Value);
  if i > 0 then Delete(Value,i,1);
  i := pos(txt_com,Value);
  if i > 0 then
  begin
    Delete(Value,i,3);
    Val (Value,i,ierr);
    if ierr = 0 then SetPort(i);
  end;
  i := pos(txt_lpt,Value);
  if i > 0 then
  begin
    Delete(Value,i,3);
    Val (Value,i,ierr);
    if ierr = 0 then SetPort(i*-1);
  end;
end;

Function TMMPort.GetPortStr:string;
begin
  If FPort = 0 then
    result := ''
  Else If FSerial then
      result := txt_com + IntToStr(Fport) + ':'+#0
  else
    result := txt_lpt + IntToStr(Abs(Fport)) + ':'+#0;
end;

procedure TMMPort.GetPortsAvail(SerialOnly: boolean;List: TStrings);
var i,j:integer;
    oldport:integer;
begin
  FParseOnly := true;
  oldport := port;
  try
    For i := 1 to 256 do
    begin
      Port := i;
      If Open then
        List.add(PortName);
      GetError;
    end;
    If not SerialOnly then
    begin
      For i := -1 downto -3 do
      begin
        Port := i;
        If Open then
          List.Add(PortName);
        GetError;
      end;
    end;
  finally
    Close;
    FParseOnly := false;
    Port := oldport;
  end;
end;
(*************** End Markus **********************)

{ Explicitly open port. Returns success/failure, check error property for details.
 This routine also begins hooking the comm messages to our invisible window we
 created upon instantiation. Will close port (if open) before re-opening. }
function TMMPort.Open: Boolean;
var
  tempStr: String;
begin
  if Fport = 0 then
    exit;
  close;
  tempstr := GetPortStr;
  cId := OpenComm(@tempStr[1], RxBufSize, TxBufSize);
  if cId < 0 then begin
    Error := parseOpenErr(cId);
    result := False;
    exit;
  end;
  If Not FParseOnly then
  begin
    If FSerial then
    begin
      SetBaudRate(FBaudRate);
      SetParityBits(FParityBits);
      SetDataBits(FDataBits);
      SetStopBits(FStopBits);
      SetFlowControl(FFlowControl);
    end;
    SetEvents(FEvents);
    EnableCommNotification(cId, FhWnd, FRxFull, FTxLow);
  End;
  result := True;
end;

{ closes the comm port, if it is open. }
procedure TMMPort.Close;
begin
  if cId >= 0 then
    CloseComm(cId);
end;

{**********************************************************************}
{*    `009           FUNCTION fCopy1()                  01/02/96       }
{                                                                      }
{This modified version will close files and free memory properly in    }
{case of an error but will pass the exception up the call chain. It    }
{also sets the date/time stamp of the copied file to that of the       }
{original file.                                                        }
{**********************************************************************}
FUNCTION fCopy(Const cSource, cDest: String): boolean;
Const BufSize = 3*4*4096; { 48Kbytes gives me the best results }
Type
  PBuffer = ^TBuffer;
  TBuffer = Array[1..BufSize] of Byte;

  var Size: Word;
      Buffer: PBuffer;
      infile,outfile: File;
      SizeDone,SizeFile: LongInt;
  begin
     if (cSource <> cDest) then
     begin
       buffer := Nil;
       Assignfile(infile,cSource);
       System.Reset(infile,1);
       try
         SizeFile := FileSize(infile);
         Assignfile(outfile,cDest);
         System.Rewrite(outfile,1);
         try
           SizeDone := 0;
           New(Buffer);
           repeat
             BlockRead(infile,Buffer^,BufSize,Size);
             Inc(SizeDone,Size);
             BlockWrite(outfile,Buffer^,Size)
           until Size < BufSize;
             FileSetDate( TFileRec(outfile).Handle,
             FileGetDate( TFileRec(infile).Handle ));
         finally
           If Buffer <> Nil Then
             Dispose(Buffer);
           System.closefile(outfile)
         end;
       finally
         System.closefile(infile);
       end;
     end
     else
       Raise EInOutError.Create('File cannot be copied onto itself')
   end {fcopy1};
(************************** TComIntf ******************************************)
procedure TMMPort.SetDestination(Value: String);
var p:byte;
begin
  p := pos(':',Value);
  if p > 3 then
  begin
    If (pos(txt_COM,Value)=1) or (pos(txt_LPT,Value)=1) then
      Delete(Value,p,1);   { COMx: oder LPTx: delete ":"}
  end;
  FDestination := Value;
end;

procedure TMMPort.SendPort(FName: TFilename);
var
  tlen,rest:longint;
  s:string;
  temp: array [0..254] of char;
  buffer: array [0..127] of char;
  FStream:TMemoryStream;
begin
  If Port = 0 then
  begin
    Application.MessageBox(Txt_SelectPort,Txt_CommOpenErr, mb_iconstop);
    exit;
  end;
  if not Open then
  begin
    Application.MessageBox(StrPCopy(temp, GetError), Txt_CommOpenErr, mb_iconstop);
    Close;
    exit;
  end else
  begin
    Fstream := tMemorystream.Create;
    Fstream.loadfromfile(FName);
    tlen := sizeof(buffer);
    rest :=  Fstream.size;
    While (rest > 0) do
    begin
      rest := Fstream.read(buffer,tlen);
      Write(@buffer,tlen);
      if rest < tlen then
        tlen := rest;
      s := GetError;
      If s <> '' then begin
        Application.MessageBox(StrPCopy(temp, s), 'Fehler beim Schreiben auf Anschlu', mb_iconstop);
        break;
      end;
    end;
    Fstream.Free;
    Close;
  end;
end;

procedure TMMPort.CopyPort(FName: TFilename);
begin
  If FDestination <> '' then
    fCopy(FName,FDestination);
end;

procedure TMMPort.SendFile(FName: TFilename);
begin
  If FSenddirect then SendPort(FName)
  else CopyPort(FName);
end;

end.

